cronjobs.controllers.module('overview',
    ['xhr'],
    () => {
        return {
            vue: true,
            name: 'gx-cronjobs-overview',
            template: '#cronjobs-overview',
            data: () => ({
                cronjobs: [],
                logCronjob: {},
                configurationCronjob: {},
                meta: {},
                ready: false
            }),
            methods: {
                openLogsModal(cronjob) {
                    const vm = this;
                    const $logsModal = $('.logs');

                    vm.logCronjob = cronjob;

                    $logsModal.on('hidden.bs.modal', () => {
                        vm.logCronjob = {};
                    });
                },
                openConfigurationModal(cronjob) {
                    const vm = this;
                    const $configurationModal = $('.configuration');

                    vm.configurationCronjob = cronjob;

                    $configurationModal.on('hidden.bs.modal', () => {
                        vm.configurationCronjob = {};
                    });
                },
                sync() {
                    const vm = this;

                    const $target = $('.cronjob-list-elements');
                    const spinner = jse.libs.loading_spinner.show($target);

                    jse.libs.xhr.get({
                        url: './admin.php?do=CronjobAjax/getCronjobs'
                    }).done(r => {
                        vm.cronjobs = r.cronjobs;
                        vm.meta = r.meta;

                        jse.libs.loading_spinner.hide(spinner);
                    }).fail(r => console.error(r));
                }
            },
            mounted() {
                const vm = this;

                vm.ready = false;
                jse.libs.xhr.get({
                    url: './admin.php?do=CronjobAjax/getCronjobs'
                }).done(r => {
                    vm.cronjobs = r.cronjobs;
                    vm.meta = r.meta;
                    vm.ready = true;
                }).fail(r => console.error(r));
            },
            init: done => done()
        }
    });